﻿var copyExtraction = {
    context: $(".v-copyExtraction"),
    datatable: null,
    initialize: function () {
        $(".h-projects", copyExtraction.context).a4autocomplete({
            ajaxAction: a4.getProjectAction("GetProjectsForAutocomplete", "Extraction"),
            altValueField: $("#SourceProjectId", copyExtraction.context),
            valueProperty: "Id",
            labelProperty: "Name",
            categoryProperty: "FolderName",
            select: function (event, data) {
                if (copyExtraction.datatable) {
                    copyExtraction.datatable.a4datatable("option", "ajaxParams", { "projectId": data.item.Id });
                    copyExtraction.datatable.a4datatable("refresh", true);
                }
                else {
                    copyExtraction.initializeDataTable(data.item.Id);
                }
            }
        });

        var projectId = $("#SourceProjectId", copyExtraction.context).val();

        if (!isNaN(projectId) && projectId > 0) {
            copyExtraction.initializeDataTable(projectId);
        }
    },
    initializeDataTable: function (projectId) {
        this.datatable = $(".h-extractionsTable", copyExtraction.context).a4datatable({
            displayColumnSelector: false,
            displaySearchBox: false,
            allowRowSelection: true,
            ajaxAction: a4.getAction("GetExtractionsForCopy", "Extraction", "Project"),
            ajaxParams: { "projectId": projectId },
            defaultSorting: "Id",
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": false },
                { "Name": "Title", "Title": resources.Title, "Data": "Title" },
                { "Name": "DtsType", "Title": resources.DataSourceType, "Data": "DtsTypeDescription" },
                { "Name": "UserName", "Title": resources.UserName, "Data": "UserName" },
                { "Name": "CreatedOn", "Title": resources.CreatedOn, "Data": "CreatedOn", "Type": "date" }
            ],
            selectRow: function (event, data) {
                copyExtraction.updateSelectedExtractions(data.selectedRows);
            },
            selectAll: function (event, data) {
                copyExtraction.updateSelectedExtractions(data.selectedRows);
            }
        });
    },
    updateSelectedExtractions: function (selectedRows) {
        $("#ExtractionIds", copyExtraction.context).val(_.pluck(selectedRows, "Id").join());
    }
}

$(document).ready(function () {
    if (copyExtraction.context.length > 0) {
        copyExtraction.initialize();
    }
});